import os
import re
import pandas as pd

folder_path = r"C:\Temp\Unlearning\Data Appendix\Cifar 20 AllCNN SubClass"

metrics = [
    "Test Accuracy",
    "Retain Accuracy",
    "Zero-Retain Forget \\(ZRF\\)",
    "Membership Inference Attack \\(MIA\\)",
    "Forget vs Retain Membership Inference Attack \\(MIA\\)",
    "Forget vs Test Membership Inference Attack \\(MIA\\)",
    "Test vs Retain Membership Inference Attack \\(MIA\\)",
    "Train vs Test Membership Inference Attack \\(MIA\\)",
    "Forget Set Accuracy \\(Df\\)",
    "Method Execution Time"
]

patterns = {metric: re.compile(f"{metric}:\\s+([0-9.]+)") for metric in metrics}

filename_pattern = re.compile(r"(?P<unlearning>\w+?)_(?P<dataset>\w+?)_(?P<model>\w+?)_seed_(?P<seed>\d+)\.txt")

results = []

for filename in sorted(os.listdir(folder_path)):
    if filename.endswith(".txt"):
        match = filename_pattern.match(filename)
        if not match:
            continue  

        meta = match.groupdict() 
        file_path = os.path.join(folder_path, filename)

        with open(file_path, "r", encoding="utf-8") as f:
            content = f.read()

        entry = {
            "Filename": filename,
            **meta  
        }

        for metric, pattern in patterns.items():
            result = pattern.search(content)
            col_name = metric.replace("\\", "")  # Clean regex slashes
            entry[col_name] = float(result.group(1)) if result else None

        results.append(entry)

df = pd.DataFrame(results)
output_csv = os.path.join(folder_path, "compiled_results.csv")
df.to_csv(output_csv, index=False)

print(f"✅ CSV saved at: {output_csv}")
